/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.StringUtils;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class FunctionsUtil {
    private static Logger logger = Logger.getLogger(FunctionsUtil.class.getName());

    public static String implodeList(String[] sarr, String sDele) {
        return OiixFunctionOps.implodeList((String[])sarr, (String)sDele);
    }

    public static String[] explodeString(String str, String sDele) {
        return OiixFunctionOps.explodeString((String)str, (String)sDele);
    }

    public static String[] intersect(String[] sa1, String[] sa2) {
        return OiixFunctionOps.intersect((String[])sa1, (String[])sa2);
    }

    public static String[] subtract(String[] sa1, String[] sa2) {
        return OiixFunctionOps.subtract((String[])sa1, (String[])sa2);
    }

    public static Boolean isEmpty(String[] a) {
        return OiixFunctionOps.isEmpty((String[])a);
    }

    public static String pathify(String path) {
        return OiixFunctionOps.pathify((String)path);
    }

    public static String getTimeStamp() {
        String timestamp;
        try {
            timestamp = OiiolLoggerUtil.getTimeStamp();
        }
        catch (Exception e) {
            timestamp = null;
        }
        if (timestamp == null) {
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS_aaa");
            timestamp = dateFormat.format(date);
        }
        return timestamp;
    }

    public static void instantiateFile(Map<Object, Object> variableMap, File sourceFile, File destinationFile, String delimiter) {
        String destinationBakFile = new String(destinationFile.getAbsolutePath() + FunctionsUtil.getTimeStamp() + ".bak");
        try {
            if (destinationFile.exists()) {
                OiixFileOps.copyFile((String)destinationFile.getAbsolutePath(), (String)destinationBakFile, (boolean)true, (boolean)true);
            }
            OiixFileOps.instantiateFile((String)sourceFile.getAbsolutePath(), (String)destinationFile.getAbsolutePath(), (HashMap)((HashMap)FunctionsUtil.sanitizeMap(variableMap)), (String)"%");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while instantiating the file", e);
        }
    }

    private static Map<Object, Object> sanitizeMap(Map<Object, Object> paramsMap) {
        if (paramsMap != null) {
            for (Map.Entry<Object, Object> e : paramsMap.entrySet()) {
                if (!(e.getValue() instanceof String)) continue;
                e.setValue(StringUtils.sanitizeString((String)((String)e.getValue())));
            }
        }
        return paramsMap;
    }

    public static void moveFileOnNodes(File sourceFile, File destinationFile, List<String> nodes) {
        try {
            if (nodes != null && nodes.size() > 0) {
                ClusterCmd clusterCmd = new ClusterCmd();
                for (String node : nodes) {
                    if (!clusterCmd.fileExists(node, sourceFile.getAbsolutePath())) continue;
                    clusterCmd.moveFilesOnNode(node, sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while moving the file", e);
        }
    }
}

